/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.cec;

import com.ibm.hsc.auiml.databeans.cec.HSCResRecoverBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.websm.lpar.DlparMemoryDialog;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import java.util.Hashtable;
import java.util.Vector;

public class HSCMemRecoverBean
extends HSCResRecoverBean {
    protected static final String MEM_INFO_DLPAR = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MEM_INFO_DLPAR", "The partition listed below are using aa certain amount of memory, but also have pending memory changes. The memory requested is not equal to the amount being used by the partition. This difference could exist temporarily because a DLAPR operation is currently in progress, or permanently if a previous DLPAR operation failed. If you are sure that no dynamic reconfiguration operation is in progress, you can correct the requested memory value by highlighting desired partitions from the table below and select the \"Recover\" button. Select \"Help\" for more information.");
    protected static final String MEM_INFO_ACTIVATE = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MEM_INFO_ACTIVATE", "The partition cannot be activated because there is not enough available system memory to satisfy the profile's required amount. However, there is some memory available that was requested by running partitions but is not being used by AIX.  This can be seen    The requested memory amount should equal the allocated amount. If not it could be because of the following: (1) A Dynamic Reconfiguration  memory operation has failed. (2) Someone is currently performing a Dynamic Reconfiguration operation. (3) Memory  has been manually stopped or started in the operating system.  If you would like to re-sync the  Allocated and Requested memory amounts and there are no current Dynamic Reconfiguration operations processing , press \"Recover\".");
    protected Vector mAllocMem = null;
    protected Vector mReqMem = null;
    protected Vector mMaxMem = null;
    protected Vector mMinMem = null;
    protected String[] mAllocColStr;
    protected ItemDescriptor[] mAllocColId;
    protected String[] mReqColStr;
    protected ItemDescriptor[] mReqColId;
    protected String[] mMaxColStr;
    protected ItemDescriptor[] mMaxColId;
    protected String[] mMinColStr;
    protected ItemDescriptor[] mMinColId;
    protected String mFreeMem;

    public HSCMemRecoverBean() {
        this.mPanelName = "RecoverMem";
        this.mAuimlClassName = "com.ibm.hsc.auiml.databeans.cec.MemRecover";
    }

    protected void loadRecoverData(Hashtable hashtable) {
        this.mMaxMem = (Vector)hashtable.get("maxMemory");
        this.mMinMem = (Vector)hashtable.get("minMemory");
        this.mReqMem = (Vector)hashtable.get("requestedMrmoey");
        this.mAllocMem = (Vector)hashtable.get("allocatedMemory");
        this.mParNames = (Vector)hashtable.get("partitionNameUser");
        this.mParIntNames = (Vector)hashtable.get("partitionNameInt");
    }

    private void loadBackendData() throws Exception {
        if (this.mParNames == null) {
            Hashtable hashtable = this.loadDataFromServer("getMemRecoverInfo");
            this.loadRecoverData(hashtable);
        }
        int n = this.mParNames.size();
        this.mAllocColId = new ItemDescriptor[n];
        this.mReqColId = new ItemDescriptor[n];
        this.mMaxColId = new ItemDescriptor[n];
        this.mMinColId = new ItemDescriptor[n];
        this.mParColId = new ItemDescriptor[n];
        for (int i = 0; i < this.mParNames.size(); ++i) {
            String string = (String)this.mParNames.elementAt(i);
            String string2 = "" + this.mAllocMem.elementAt(i);
            String string3 = "" + this.mReqMem.elementAt(i);
            String string4 = "" + this.mMaxMem.elementAt(i);
            String string5 = "" + this.mMinMem.elementAt(i);
            this.mParColId[i] = new ItemDescriptor("parRC" + i, string);
            this.mAllocColId[i] = new ItemDescriptor("allRC" + i, string2);
            this.mReqColId[i] = new ItemDescriptor("reqRC" + i, string3);
            this.mMaxColId[i] = new ItemDescriptor("maxRC" + i, string4);
            this.mMinColId[i] = new ItemDescriptor("minRC" + i, string5);
        }
    }

    protected boolean saveChanges() throws Exception {
        int n;
        int[] nArray = this.getRecoverTableSelection();
        Vector vector = new Vector();
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            vector.addElement(this.mParIntNames.elementAt(n2));
        }
        for (n = 0; n < vector.size(); ++n) {
            System.out.println("sel par: " + vector.elementAt(n));
        }
        Object[] objectArray = new Object[]{vector};
        return this.saveDataToServer("recoverMem", objectArray);
    }

    protected void showDLPARDialog() {
        if (this.mLparContainer != null) {
            DlparMemoryDialog.showDialog(this.mLparContainer);
        }
    }

    public void setAllocColList(ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.mAllocColId = itemDescriptorArray;
    }

    public ItemDescriptor[] getAllocColList() {
        return this.mAllocColId;
    }

    public String[] getAllocColSelection() {
        return this.mAllocColStr;
    }

    public void setAllocColSelection(String[] stringArray) throws IllegalUserDataException {
        this.mAllocColStr = stringArray;
    }

    public void setReqColList(ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.mReqColId = itemDescriptorArray;
    }

    public ItemDescriptor[] getReqColList() {
        return this.mReqColId;
    }

    public String[] getReqColSelection() {
        return this.mReqColStr;
    }

    public void setReqColSelection(String[] stringArray) throws IllegalUserDataException {
        this.mReqColStr = stringArray;
    }

    public void setMaxColList(ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.mMaxColId = itemDescriptorArray;
    }

    public ItemDescriptor[] getMaxColList() {
        return this.mMaxColId;
    }

    public String[] getMaxColSelection() {
        return this.mMaxColStr;
    }

    public void setMaxColSelection(String[] stringArray) throws IllegalUserDataException {
        this.mMaxColStr = stringArray;
    }

    public void setMinColList(ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.mMinColId = itemDescriptorArray;
    }

    public ItemDescriptor[] getMinColList() {
        return this.mMinColId;
    }

    public String[] getMinColSelection() {
        return this.mMinColStr;
    }

    public void setMinColSelection(String[] stringArray) throws IllegalUserDataException {
        this.mMinColStr = stringArray;
    }

    public String getFreeMem() {
        return this.mFreeMem;
    }

    public void setFreeMem(String string) throws IllegalUserDataException {
        this.mFreeMem = string;
    }

    public void load() {
        try {
            this.mLoadException = null;
            super.load();
            this.mFreeMem = "";
            this.mAllocColStr = new String[0];
            this.mAllocColId = new ItemDescriptor[0];
            this.mReqColStr = new String[0];
            this.mReqColId = new ItemDescriptor[0];
            this.mMaxColStr = new String[0];
            this.mMaxColId = new ItemDescriptor[0];
            this.mMinColStr = new String[0];
            this.mMinColId = new ItemDescriptor[0];
            this.loadBackendData();
            this.mInfoArea = this.mFromActivate ? MEM_INFO_ACTIVATE : MEM_INFO_DLPAR;
        }
        catch (Throwable throwable) {
            this.mLoadException = throwable;
            this.handleException(throwable, this.mActivateMsg);
        }
    }
}

